/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.option;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class SpruceBooleanOption
extends SpruceOption {
    private final Supplier<Boolean> getter;
    private final Consumer<Boolean> setter;
    private final boolean colored;

    public SpruceBooleanOption(String key, Supplier<Boolean> getter, Consumer<Boolean> setter, @NotNull TooltipData tooltip) {
        this(key, getter, setter, tooltip, false);
    }

    public SpruceBooleanOption(String key, Supplier<Boolean> getter, Consumer<Boolean> setter, @NotNull TooltipData tooltip, boolean colored) {
        super(key);
        this.getter = getter;
        this.setter = setter;
        this.colored = colored;
        this.setTooltip(tooltip);
    }

    public void set(String value) {
        this.set("true".equals(value));
    }

    public void set() {
        this.set(!this.get());
    }

    private void set(boolean value) {
        this.setter.accept(value);
    }

    public boolean get() {
        return this.getter.get();
    }

    public boolean isColored() {
        return this.colored;
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceButtonWidget button = new SpruceButtonWidget(position, width, 20, this.getDisplayText(), btn -> {
            this.set();
            btn.setMessage(this.getDisplayText());
        });
        this.getTooltip().ifPresent(button::setTooltip);
        return button;
    }

    public class_2561 getDisplayText() {
        boolean value = this.get();
        class_2561 toggleText = SpruceTexts.getToggleText(value);
        if (this.colored) {
            toggleText = toggleText.method_27661().method_10862(toggleText.method_10866().method_10977(value ? class_124.field_1060 : class_124.field_1061));
        }
        return this.getDisplayText(toggleText);
    }

    public static class Builder
    extends BaseBuilder<Builder, SpruceBooleanOption> {
        public Builder(String key, Supplier<Boolean> getter, Consumer<Boolean> setter) {
            super(key, getter, setter);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpruceBooleanOption build() {
            return new SpruceBooleanOption(this.key, this.getter, this.setter, this.tooltip, this.colored);
        }
    }

    protected static abstract class BaseBuilder<B extends BaseBuilder<B, T>, T extends SpruceBooleanOption>
    extends SpruceOption.Builder<B, T> {
        protected final Supplier<Boolean> getter;
        protected final Consumer<Boolean> setter;
        protected boolean colored;

        public BaseBuilder(String key, Supplier<Boolean> getter, Consumer<Boolean> setter) {
            super(key);
            this.getter = getter;
            this.setter = setter;
        }

        public B colored() {
            return this.colored(true);
        }

        public B colored(boolean colored) {
            this.colored = colored;
            return (B)((BaseBuilder)this.self());
        }
    }
}

